def cart_item_count(request):
    """
    Devuelve la cantidad total de unidades del carrito
    para usarla en cualquier template (navbar, etc.).
    """
    cart = request.session.get("cart", {})

    total_qty = 0
    for item in cart.values():
        qty = item.get("qty", 0)
        try:
            total_qty += int(qty)
        except (TypeError, ValueError):
            continue

    return {"cart_item_count": total_qty}
